//
//  TWStreamTableViewCell.m
//  Twitch
//
//  Created by Auston Stewart on 11/25/13.
//  Copyright (c) 2013 Justin.tv. All rights reserved.
//

#import "TWStreamTableViewCell.h"
#import "UIFont+Twitch.h"
#import "NSString+Twitch.h"

NSString *const TWStreamTableViewCellReuseIdentifier = @"TWStreamTableViewCellReuseIdentifier";

@implementation TWStreamTableViewCell
{
	UILabel *_broadcastTitleLabel;
}

+ (NSString *)reuseIdentifier
{
	return TWStreamTableViewCellReuseIdentifier;
}

+ (CGFloat)preferredHeight
{
	return 100.f;
}

- (void)commonInitialization
{
	[super commonInitialization];
	self.imageSize = CGSizeMake(142.f, 80.f);
	self.imageView.contentMode = UIViewContentModeScaleAspectFill;
	self.placeholderImageName = @"404_sdk_iphone_lists";
	self.accessoryPadding = UIEdgeInsetsMake(0.f, 25.f, 0.f, 10.f);
	self.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
	
	self.selectedBackgroundView = [[UIView alloc] initWithFrame:CGRectMake(0.f, 0.f, self.frame.size.width, self.frame.size.height)];
	self.selectedBackgroundView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
	self.selectedBackgroundView.backgroundColor = [UIColor twitchCellBackgroundColorPressed];
}

- (void)prepareForReuse
{
	[super prepareForReuse];
	
	_broadcastTitleLabel.hidden = YES;
	self.textLabelPositionAdjustment = CGPointZero;
	self.detailTextLabelPositionAdjustment = CGPointMake(0.f, 2.f);
}

- (void)setChannelDisplayName:(NSString *)channelDisplayName
{
	_channelDisplayName = [channelDisplayName copy];
	self.textLabel.text = _channelDisplayName;
}

- (void)setBroadcastTitle:(NSString *)broadcastTitle
{
	if (broadcastTitle.length) {
		
		_broadcastTitle = [broadcastTitle copy];
		
		if (!_broadcastTitleLabel) {
			
			_broadcastTitleLabel = [[UILabel alloc] init];
			_broadcastTitleLabel.numberOfLines = 1;
			_broadcastTitleLabel.textAlignment = NSTextAlignmentLeft;
			_broadcastTitleLabel.lineBreakMode = NSLineBreakByTruncatingTail;
			_broadcastTitleLabel.font = [UIFont twitchCellBroadcastTitleFont];
			_broadcastTitleLabel.textColor = [UIColor twitchCellBroadcastTitleTextColor];
			[self.contentView addSubview:_broadcastTitleLabel];
		}
		_broadcastTitleLabel.text = _broadcastTitle;
		_broadcastTitleLabel.hidden = NO;
		
		// This will force a layout of cell
		self.textLabelPositionAdjustment = CGPointMake(0.f, -7.f);
		self.detailTextLabelPositionAdjustment = CGPointMake(0.f, 12.f);
	}
}

- (void)setGameName:(NSString *)gameName
{
	_gameName = [gameName copy];
	
	NSString *localizedGameNameString = TKLocalizedString(@"playing %@",@"Enlarged stream cell game name text");
	NSRange gameNameSpecifierRange = [localizedGameNameString tw_rangeOfStringSpecifier:1];
	NSMutableAttributedString *attributedGameName = [[NSMutableAttributedString alloc] initWithString:[NSString		stringWithFormat:TKLocalizedString(@"playing %@",@"Enlarged stream cell game name text"),_gameName]];
	
	if (gameNameSpecifierRange.location != NSNotFound) {
		[attributedGameName addAttribute:NSFontAttributeName value:[UIFont twitchLiveChannelCellViewerCountBoldFont] range:NSMakeRange(gameNameSpecifierRange.location,_gameName.length)];
	}
	
	self.detailTextLabel.attributedText = attributedGameName;
}

- (void)setViewerCount:(NSInteger)viewerCount
{
	_viewerCount = viewerCount;
	NSString *viewersString = [@(_viewerCount) formattedLocalizedNumericRepresentation];
	NSString *localizedViewerCountString = TKLocalizedString(@"%@ viewers", @"Enlarged stream cell viewer count text");
	NSRange viewCountSpecifierRange = [localizedViewerCountString tw_rangeOfStringSpecifier:1];
	NSMutableAttributedString *attributedViewerCount = [[NSMutableAttributedString alloc] initWithString:[NSString stringWithFormat:TKLocalizedString(@"%@ viewers", @"Enlarged stream cell viewer count text"),viewersString]];
	
	if (viewCountSpecifierRange.location != NSNotFound) {
		[attributedViewerCount addAttribute:NSFontAttributeName value:[UIFont twitchLiveChannelCellViewerCountBoldFont] range:NSMakeRange(viewCountSpecifierRange.location,viewersString.length)];
	}
	
	self.detailTextLabel.attributedText = attributedViewerCount;
}

- (void)layoutSubviews
{
	[super layoutSubviews];
	
	// Make space for the broadcast title
	if (_broadcastTitleLabel) {
		CGFloat leftMargin = self.imageSize.width + (2.f * self.imagePadding);
		CGFloat rightMargin = self.accessoryView ? self.accessoryView.frame.size.width + self.accessoryPadding.left + self.accessoryPadding.right : 0.f;
		[_broadcastTitleLabel sizeToFit];
		_broadcastTitleLabel.frame = CGRectMake(leftMargin, floorf(([self.class preferredHeight] - _broadcastTitleLabel.frame.size.height) / 2.f) + 2.f, self.contentView.frame.size.width - leftMargin - rightMargin, _broadcastTitleLabel.frame.size.height);
	}
}

@end
